% Audio Mixer
% Author: Pouyan R. Fard

guitar=wavread('guitar.wav');
bass=wavread('bass.wav');
drums=wavread('drums.wav');

Fs=44100;

guitar_seg=guitar(1:10*Fs);
bass_seg=bass(1:10*Fs);
drums_seg=drums(1:10*Fs);


figure,
subplot(3,1,1),
plot(guitar_seg),title('Guitar Track'),ylabel('Amplitude');
subplot(3,1,2),
plot(bass_seg),title('Bass Track'),ylabel('Amplitude');
subplot(3,1,3),
plot(drums_seg),title('Drums Track'),xlabel('Time(s)'),ylabel('Amplitude');

mixed=guitar_seg+drums_seg+bass_seg;

%%
figure
subplot(411); specgram(mixed,1024,Fs); c = caxis;title('Mixed');
subplot(412); specgram(guitar_seg,1024,Fs); caxis(c);title('Guitar');
subplot(413); specgram(bass_seg,1024,Fs); caxis(c);title('Bass');
subplot(414); specgram(drums_seg,1024,Fs); caxis(c);title('Drums');
%%

mixed1=guitar_seg*0.4+drums_seg+bass_seg*3;

sound(mixed,Fs);
% sound(mixed1,Fs);


%%
step=1/length(bass_seg);
ramp=[step:step:1]';

bass_new=bass_seg.*ramp;

mixed2=drums_seg+guitar_seg+bass_new;
sound(mixed2,Fs);


